/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class MemoryMonitorFrame
extends Frame
implements ActionListener,
Runnable {
    Panel gridPanel;
    Panel panel;
    Label freeMemLabel;
    Label usedMemLabel;
    Label totalMemLabel;
    TextField freeMemField;
    TextField totalMemField;
    TextField usedMemField;
    long freeMemory;
    long totalMemory;
    long usedMemory;
    Button gcButton;
    Insets insets = new Insets(40, 10, 10, 10);
    Thread pollingThread;
    boolean polling = false;
    boolean stopPolling = false;

    public MemoryMonitorFrame() {
        this.setTitle("Memory Monitor");
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(15);
        this.panel = new Panel(borderLayout);
        this.gridPanel = new Panel(new GridLayout(3, 2, 10, 5));
        this.panel.add("Center", this.gridPanel);
        ((Component)this).setBackground(Color.white);
        this.add("Center", this.panel);
        this.totalMemLabel = new Label("Total memory in system", 2);
        this.gridPanel.add(this.totalMemLabel);
        this.totalMemField = new TextField();
        this.totalMemField.setColumns(20);
        this.totalMemField.setEditable(false);
        this.gridPanel.add(this.totalMemField);
        this.freeMemLabel = new Label("Free memory", 2);
        this.gridPanel.add(this.freeMemLabel);
        this.freeMemField = new TextField();
        this.freeMemField.setColumns(20);
        this.freeMemField.setEditable(false);
        this.gridPanel.add(this.freeMemField);
        this.usedMemLabel = new Label("Used memory", 2);
        this.gridPanel.add(this.usedMemLabel);
        this.usedMemField = new TextField();
        this.usedMemField.setColumns(20);
        this.usedMemField.setEditable(false);
        this.gridPanel.add(this.usedMemField);
        this.gcButton = new Button("Collect Garbage");
        this.gcButton.addActionListener(this);
        this.panel.add("South", this.gcButton);
        this.updateFields();
        this.pack();
        this.show();
        this.requestFocus();
    }

    public synchronized void startPolling() {
        if (this.pollingThread == null) {
            this.pollingThread = new Thread((Runnable)this, "Memory Monitor Polling");
            this.pollingThread.setDaemon(true);
        }
        if (!this.polling) {
            this.stopPolling = false;
            this.pollingThread.start();
        }
    }

    private synchronized void updateFields() {
        this.freeMemory = Runtime.getRuntime().freeMemory();
        ((TextComponent)this.freeMemField).setText(new Long(this.freeMemory).toString());
        this.totalMemory = Runtime.getRuntime().totalMemory();
        ((TextComponent)this.totalMemField).setText(new Long(this.totalMemory).toString());
        this.usedMemory = this.totalMemory - this.freeMemory;
        ((TextComponent)this.usedMemField).setText(new Long(this.usedMemory).toString());
        this.gridPanel.invalidate();
        this.gridPanel.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        long l = this.freeMemory;
        System.out.println("Collecting garbage...");
        Runtime.getRuntime().gc();
        this.updateFields();
        System.out.println("Reclaimed " + (this.freeMemory - l) + " bytes");
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void run() {
        this.polling = true;
        while (!this.stopPolling) {
            try {
                Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
            this.updateFields();
        }
        this.polling = false;
    }

    public void dispose() {
        if (this.polling) {
            this.stopPolling = true;
        }
        this.pollingThread = null;
        super.dispose();
    }
}

